############################################################################################################
# Version: 18 December 2017
# 
# Author: Suhui Ma
#
# Contents: r code of figures and table of the manuscript:
#           Ma, S., He, F., Tian, D., Zou, D., Yan, Z., Yang, Y., Zhou, T., Huang, K., Shen, H., and Fang, J.: 
#           Variations and determinants of carbon content in plants: a global synthesis, Biogeosciences Discuss., 
#           https://doi.org/10.5194/bg-2017-322, in review, 2017. 
#
# Herb: Herbaceous plants
# EBW: Evergreen broad-leaved Woody plants;
# DBW: Deciduous broad-leaved Woody plants;
# CT: Coniferous tree;
# MAT: Mean Annual Temperature;  MAP: Mean Annual Precipitation; 
# Repro: Reproductive organ
# References can be found in the supporting information.
#
############################################################################################################

setwd('file path')
data <- read.csv('Global plant C content dataset.csv')
OrganID=c('Reproductive organ','Root','Leaf','Stem')
Lifeform=c('Crop','Herb','Fern','Vine','Bamboo','Shrub','DBT','EBT','CT')

############################ Table 1 and t.test  #############################
CData<- data

OneInf.LF<-function(Da,x){
  R1<-tapply(Da$Carbon,x,mean)
  R5<-tapply(Da$Carbon,x,sd)
  R6<-tapply(Da$Carbon,x,length)
  R2<-tapply(Da$Carbon,x,median)
  R4<-tapply(Da$Carbon,x,min)
  R3<-tapply(Da$Carbon,x,max)
  cbind(R6,R1,R5,R4,R2,R3)
}
### four organs
Result <- OneInf.LF(CData,CData$Organ)
colnames(Result) <- c('N','Mean','SD','Min','Median','Max')
Result

TwoInf.LF=function(x1,x2){
  Mean=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),mean))
  SD=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),sd))
  Length=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),length))
  Median=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),median))
  Min=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),min))
  Max=with(CData,aggregate(CData$Carbon,list(x1=x1,x2=x2),max))
  cbind(Mean,SD,Length,Median,Min,Max)
}
### four organs and life forms
LifeForm.organ<-TwoInf.LF(CData$Life.form.1,CData$Organ)
LifeForm.organ

LifeForm.organ2<-TwoInf.LF(CData$Life.form.2,CData$Organ)
LifeForm.organ2

library(agricolae) 

###### test 

###  woody Vs Herb
for(i in 1:4){
  df<-data[which(data$Organ==OrganID[i]),]
  df.w=df[which(df$Life.form.1=='Woody'),]
  summary(df.w$LF3)
  df.h=df[which(df$Life.form.1=='Herb'),]
  summary(df.h$LF3)
  print(i)
  print(OrganID[i])
  print(t.test(df.w$Carbon,df.h$Carbon))
}

library(agricolae)
for(i in 1:4){
  df<-data[which(data$Organ==OrganID[i]),]
  df.edc=df[df$Life.form.2=='EBW'|df$Life.form.2=='DBW'|df$Life.form.2=='CT',]
  df.edc<-df.edc[is.na(df.edc$Life.form.2)==F,]
  summary(df.edc$Life.form.2)
  
  result<-aov(Carbon~Life.form.2,data=df.edc)
  print(OrganID[i])
  print(summary(result))
  result1<-LSD.test(result,"Life.form.2",p.adj="bonferroni")
  result1<-HSD.test(result,"Life.form.2", alpha = 0.05, group=TRUE)
  print(result1)
  
  df.d<-subset(df.edc,Life.form.2=='DBW');
  df.e<-subset(df.edc,Life.form.2=='EBW');
  df.c<-subset(df.edc,Life.form.2=='CT');
  
  print(t.test(df.c$Carbon,df.d$Carbon))
  print(t.test(df.c$Carbon,df.e$Carbon))
  
}
result <- LSD.test(result,"F1",p.adj="bonferroni")
result

#### t.test && C content with 50 %, 45.45% and IPCC values

data.ro <- subset(data,Organ=='Reproductive organ')
t.test(data.ro$Carbon,alternative='less', mu=50)
t.test(data.ro$Carbon,alternative='less', mu=45.45)

data.r <- subset(data,Organ=='Root')
t.test(data.r$Carbon,alternative='less', mu=50)
t.test(data.r$Carbon,alternative='greater', mu=45.45)

data.l <- subset(data,Organ=='Leaf')
t.test(data.l$Carbon,alternative='less', mu=50)
t.test(data.l$Carbon,alternative='greater', mu=45.45)

data.s <- subset(data,Organ=='Stem')
t.test(data.s$Carbon,alternative='less', mu=50)
t.test(data.s$Carbon,alternative='greater', mu=45.45)

data.s <- subset(data,Organ=='Stem')
data_S_Wo <- subset(data.s,Life.form.1=='Woody')
t.test(data.s$Carbon,alternative='greater', mu=47) ######### p value < 0.001

data_S_DBW <- subset(data.s,Life.form.2=='DBW')
t.test(data_S_DBW$Carbon,alternative='greater', mu=47) ######### p value < 0.001
t.test(data_S_DBW$Carbon,alternative='less', mu=48) ######### p value < 0.001

data_S_EBW <- subset(data.s,Life.form.2=='EBW')
t.test(data_S_EBW$Carbon,alternative='greater', mu=47) ######### p value < 0.001
t.test(data_S_EBW$Carbon,alternative='less', mu=48) ######### p value < 0.001

data_S_CT <- subset(data.s,Life.form.2=='CT')
t.test(data_S_CT$Carbon,alternative='greater', mu=47) ######### p value < 0.001
t.test(data_S_CT$Carbon,alternative='less', mu=51) ######### p value < 0.001


############################ Figure 2 hist plot #############################
Organ2 <-c('Reproductive organ','Root','Leaf','Stem')
par(mfrow=c(2,2),mar=c(0.4,0.4, 0.4, 0.4),oma=c(3,3,1,1),family = 'serif')
Others=matrix(0,7,4)

for(i in 1:4){
  
  datai=data[data$Organ==OrganID[i],]
  Xlab=c('Reproductive organ carbon content (%)','Root carbon content (%)','Leaf carbon content (%)','Stem carbon content (%)')
  hist(datai$Carbon,freq = FALSE,ylim=c(0,0.14),
       xlim=c(25,70),breaks=20,main='',yaxt='n',
       xaxt='n',col='gray90',border='gray55')
  lines(density(datai$Carbon), col="gray55", lwd=2)
 
  
  if(i<=2){ 
    axis(1,at=c(30,40,50,60,70),labels = FALSE,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=1,family = 'serif')
  }
  
  if(i>=3){
    #X axis
    mtext(text='Carbon content (%)',side=1,at=50,family = 'serif',line=1.5,cex=1) 
    axis(1,at=c(30,40,50,60,70),labels = c('30','40','50','60','70'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=1.1,family = 'serif')
  }
  
  if(i==1 || i==3){
    mtext(text='Relative frequency (%)',side=2,at=0.06,family = 'serif',line=1.5,cex=1)
    axis(2,at=c(0,0.02,0.04,0.06,0.08,0.10,0.12),labels = c('0','2','4','6','8','10','12'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=1.1,family = 'serif')
  }
  
  if(i==2 || i==4){
    axis(2,at=c(0,0.02,0.04,0.06,0.08,0.10,0.12),labels = FALSE,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=1.1,family = 'serif')
  }
  
  # num 
  Xlab=c('(a) Reproductive organ','(b) Root','(c) Leaf','(d) Stem')
  if(i == 1){text(25,0.135,paste(Xlab[i]),cex=1.1,adj=0)}
  if(i > 1)text(25,0.135,paste(Xlab[i]),cex=1.1,adj=0)
  
  ####CV
  library(moments)### 
  Others[1,i]=mean(datai$Carbon)
  Others[2,i]=median(datai$Carbon)
  Others[3,i]=sd(datai$Carbon)
  Others[4,i]=sd(datai$Carbon)/mean(datai$Carbon)*100
  Others[5,i]=kurtosis(datai$Carbon);
  Others[6,i]=skewness(datai$Carbon);
  Others[7,i]=length(datai$Carbon);
  # statistic
  Mean=c('45.01','45.64','46.85','47.88')
  Median=c('45.00','45.80','47.20','48.01')
  SD=c('5.23','4.95','3.98','3.49')
  Len=c('142','2306','18124','3754')
  CV=c('0.12','0.11','0.09','0.07')
  Kurtosis=c('3.62','3.99','4.77','5.06')
  Skewness=c('0.15','-0.37','-0.62','-0.47')
  A=c(0,0,0,0);
  B=c(0.7,0.7,0.7,0.7)
  C=c(-1.6,-1.60,-1.60,-1.60)
  D=c(-3.0,-2.5,-2.2,-2.5)
  
  text(58,0.11,paste('Mean:'),cex=1.1,adj=0)
  text(71,0.11,paste(Mean[i]),cex=1.1,adj=1)
  
  text(58,0.097,paste('Median:'),adj=0,cex=1.1)
  text(71,0.097,paste(Median[i]),adj=1,cex=1.1)
  
  text(58,0.084,paste('SD:'),adj=0,cex=1.1)
  text(71,0.084,paste(SD[i]),adj=1,cex=1.1)
  
  text(58,0.071,paste('CV:'),adj=0,cex=1.1)
  text(71,0.071,paste(CV[i]),adj=1,cex=1.1)
  
  text(58,0.058,paste('Kurtosis:'),adj=0,cex=1.1)
  text(71,0.058,paste(Kurtosis[i]),adj=1,cex=1.1)
  
  text(58,0.045,paste('Skewness:'),adj=0,cex=1.1)
  text(71,0.045,paste(Skewness[i]),adj=1,cex=1.1)
  
  text(58,0.032,expression(paste(italic('n'),':')),adj=0,cex=1.1)
  text(71,0.032,paste(length(datai$Carbon)),adj=1,cex=1.1)
  
  box()
}
############################ Figure 3 latitudinal trend #####################
data[,'La_abs'] <- abs(data$Latitude)
CData <- data

### A function to make a plot and add the axis for each plot
Plot_axis <- function(T,Ylab,o){
  #data select
  if(T==1){dataT=dt_c$Carbon~dt_c$La_abs;Ylab1=Ylab;Xlab='Latitude ()';Xlim=c(0,74);Yaxt='s'}
  if(T==2){dataT=dt_c$Carbon~dt_c$Mean.Annual.Temperature;Ylab1='';Xlab='MAT ()';Xlim=c(-12,32);Yaxt='n'}
  if(T==3){dataT=dt_c$Carbon~dt_c$Mean.Annual.Precipitation;Ylab1='';Xlab='MAP (mm)';Xlim=c(0,4800);Yaxt='n'}
  #plot
  plot(dataT,pch=16,col=NA,
       cex=0.5,cex.axis=0.7,ylab=Ylab1,xlab=Xlab,yaxt='n',xaxt='n',
       ylim=c(25,75),xlim=Xlim,family = 'serif')
  box(which = "plot", lty = "solid", lwd=0.7)
  Organ=c('All organs','Reproductive organ','Root','leaf','Stem')
  Geo=c('Latitude ()','MAT ()','MAP (mm)')
  xh=c('a','b','c','d','e','f','g','h','i','j','k','l','m')
  #add p_value
  if(o==1){
    
    if(T==1){
      text(0.07*(max(Xlim)-min(Xlim)),70, paste('(',xh[3*(o-1)+T],')',sep=''))
      text(0.45*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
      text(0.74*(max(Xlim)-min(Xlim)),70, paste(' = 0.147 ',sep=''),pos=2)
    }
    if(T==2){
      text(-0.2*(max(Xlim)-min(Xlim)),70, paste('(',xh[3*(o-1)+T],')',sep=''))
      text(0.25*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
      text(0.53*(max(Xlim)-min(Xlim)),70, paste(' = 0.125 ',sep=''),pos=2)
    }
    if(T==3){
      text(0.07*(max(Xlim)-min(Xlim)),70, paste('(',xh[3*(o-1)+T],')',sep=''))
      text(0.45*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
      text(0.73*(max(Xlim)-min(Xlim)),70, paste(' = 0.009 ',sep=''),pos=2)
    }
  }
  if(o>1){
    if(T!=2){text(0.07*(max(Xlim)-min(Xlim)),70, paste('(',xh[3*(o-1)+T],')',sep=''))
      if(3*(o-1)+T !=10  & 3*(o-1)+T !=12){
        text(0.45*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
        text(0.73*(max(Xlim)-min(Xlim)),70, paste(' < 0.001 ',sep=''),pos=2)}
      if(3*(o-1)+T ==10){
        text(0.45*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
        text(0.73*(max(Xlim)-min(Xlim)),70, paste(' = 0.053 ',sep=''),pos=2)}
      if(3*(o-1)+T ==12){
        text(0.45*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
        text(0.73*(max(Xlim)-min(Xlim)),70, paste(' = 0.421 ',sep=''),pos=2)}
    }
    
    if(T==2){text(-0.2*(max(Xlim)-min(Xlim)),70, paste('(',xh[3*(o-1)+T],')',sep=''))
      
      text(0.25*(max(Xlim)-min(Xlim)),70, expression(paste(italic(p))),pos=2)
      text(0.53*(max(Xlim)-min(Xlim)),70, paste(' < 0.001 ',sep=''),pos=2)
    }
  }
  
  
  
  if(T==1){
    mtext(text=Ylab1,side=2,at=50,family = 'serif',line=1.5,cex=0.65)
    axis(2,at=c(30,40,50,60,70),labels = c('30','40','50','60','70'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.85,family = 'serif')
  }
  
  if(T>=2){
    axis(2,at=c(30,40,50,60,70),labels = FALSE,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.7,family = 'serif')
  }
  
  if(o<=3){
    if(T==1){ 
      axis(1,at=c(0,20,40,60),labels =FALSE ,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.7,family = 'serif')
    }
    
    if(T==2){ 
      axis(1,at=c(-10,0,10,20,30),labels =FALSE ,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.7,family = 'serif');
    }
    if(T==3){ 
      axis(1,at=c(0,2000,4000),labels =FALSE ,tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.7,family = 'serif')
    }
  }
  
  X.at=c(39,10,2300)
  if(o==4){
    mtext(text=Geo[T],side=1,at=X.at[T],family = 'serif',line=1.5,cex=0.65);
    if(T==1){ 
      axis(1,at=c(0,20,40,60),labels = c('0','20','40','60'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.85,family = 'serif');
    }
    
    
    if(T==2){ 
      axis(1,at=c(-10,0,10,20,30),labels = c('-10','0','10','20','30'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.85,family = 'serif');
    }
    
    if(T==3){ 
      axis(1,at=c(0,2000,4000),labels = c('0','2000','4000'),tcl=0.2,mgp=c(3, 0.2, 0),cex.axis=0.85,family = 'serif')
    }
    
  }
}
### A function to add point to each plot
Point_add <- function(T){
  if(T==1){dataT=dt_c$Carbon~dt_c$La_abs}
  if(T==2){dataT=dt_c$Carbon~dt_c$Mean.Annual.Temperature}
  if(T==3){dataT=dt_c$Carbon~dt_c$Mean.Annual.Precipitation}
  pT=lm(dataT);ST=summary(pT);pvalueT=ST$coefficients[2,4]
  points(dataT,col='gray70',cex=0.8,pch=16)
  
}


Mytable12 <- matrix(0,12,4)
par(mfrow=c(4,3),mar=c(0.4,0.4, 0.4, 0.4),oma=c(3,3,1,1),family = 'serif')

### plot
for(o in 1:4){
  
  #selcet data based on the organs
  if(o==1){ dt_c = CData[CData$Organ=='Reproductive organ',];Ylab='Repr carbon content' }
  if(o==2){ dt_c = CData[CData$Organ=='Root',];Ylab='Root carbon content (%)'}
  if(o==3){ dt_c = CData[CData$Organ=='Leaf',];Ylab='Leaf carbon content (%)'}
  if(o==4){ dt_c = CData[CData$Organ=='Stem',];Ylab='Stem carbon content (%)'}
  
  for(i in 1:3){
    #i=1
    Plot_axis(i,Ylab,o);
    Point_add(i)
    
    #selcet data based on the variables data
    T=i
    if(T==1){dataT=dt_c$Carbon~dt_c$La_abs}
    if(T==2){dataT=dt_c$Carbon~dt_c$Mean.Annual.Temperature}
    if(T==3){dataT=dt_c$Carbon~dt_c$Mean.Annual.Precipitation}
    
    #add the line to each plot
    pT=lm(dataT);ST=summary(pT);pvalueT=ST$coefficients[2,4]
    if(pvalueT <= 0.05){abline(pT,lwd=2,col='red')}
    if(pvalueT > 0.05){abline(pT,lwd=2,lty=2,col='red')}
    XX=(2*(3*(o-1)+T)-1);XY=2*(3*(o-1)+T);
    
    Stat=c(ST$df[2],ST$fstatistic[1],ST$r.squared,ST$coefficients[2,4])
    Mytable12[3*(o-1)+T,]=Stat;
    
  }
}

############################ Figure 4 variation partitioning ################
library(vegan)
data1=data.frame(data$Carbon,data$Mean.Annual.Temperature,data$Mean.Annual.Precipitation,data$Life.form.1,data$Organ)
names(data1)=c('Carbon','MAT','MAP','Life.form.1','Organ')
data2=data1[complete.cases(data1),]

par(mfrow=c(2,2))
for(i in 1:4){
  print(OrganID[i])
  datai=subset(data2,Organ==OrganID[i])
  Lifeform <- class.ind(datai$Life.form.1)[,-1]
  Climate <- datai[,c('MAT','MAP')]
  Carbon <- datai$Carbon
  varp1 <- varpart(Carbon,Climate,Lifeform)
  plot(varp1,digits=2, bg = c("hotpink","skyblue"))
  print(varp1)
}


